.H 1 "Nrtxpi Window"
This window attaches rtpi to processes running under the
real-time multi-tasking executive NRTX.
A separate window hierarchy may be created for each process.
.P
The window allows the debugger to attach to existing processes.
Programs must be down-loaded from outside of rtpi with the loading 
programs supplied with the NRTX software.
To debug the first instructions in NRTX processes
use the -h option in the loading software.
Similar to rthang, this suspends a down-loaded process before
it executes the first instruction.
.P
While NRTX does not support core dumps (there is no file system!),
a process that dies from a certain fatal errors,
such as a bus error signal, freezes its memory instead of exiting,
allowing the Nrtxpi window to attach to the process and see what caused
the error.
Sending one of these frozen processes a SIGKILL signal forces the process to
give up its memory and exit.
.H 2 "Nrtxpi Layout"
The title bar identifies the window as an Nrtxpi window and
lists the names of both the debug agent and processor.
Lines in the window list NRTX processes and are in the format:
.DS I N
processor_name:pid program
.DE
.P
The lines are sorted by the process id numbers.
Program is the name of the executable file the process was down-loaded from.
.H 2 "Nrtxpi Menu Bar"
The menu bar has entries that update the contents of the window and
allow the NRTX kernel to be debugged.
.VL 12 1
.LI ps
Run the ps command on the processor and use the output to
update the contents of the window.
The lines in the window change if a new process was down-loaded from the host,
a new process was spawned with exec(), or a process exited.
.LI "kernel pi"
Open the Dbmonpi window for the processor,
allowing the NRTX operating system kernel to be debugged.
The kernel and its applications may be debugged concurrently.
However, suspending the kernel suspends the NRTX agent process that 
services NRTX debug requests, so debugging requests for NRTX
processes are not serviced until the kernel is resumed.
.H 2 "Nrtxpi Keyboard"
Syntax
.DS I N
pid program
.DE
.P
The keyboard language accepts a process id and the name of a symbol table file
and may be used to open running programs.
The keyboard is used infrequently since the "ps" entry in the menu bar
supplies this information automatically. 
However, if the program name returned by the "ps" command is incorrect
because the file moved or was renamed, the keyboard may be used to
change it.
.H 2 "Nrtxpi Line Menu"
.VL 15 1
.LI "open process"
Attach the debugger to the process and open its Process window.
The executable file containing the symbol table must be in the
current working directory or be a full path name.
.LI "take over"
Similar to "open process", except instead of creating a new set of
windows a pop-up window asks you to choose an existing set
of windows to take over.
To work successfully, the process chosen must
be another instance of the same program on the same processor
and have its text segment relocated to the same start address. 
The start address is the same if the new and old processes share
their text segments,
or if reloading the programs causes the same memory locations to be allocated.
For example, if a single program is loaded and it exits, its memory is freed.
Since NRTX uses a first-fit memory allocation algorithm if the same program
is reloaded it will be relocated to the same address.
.P
If successful the debugger detaches itself from the process it
was previously controlling and then attaches the window hierarchy to the
new process.
In addition to the windows, the new process inherits all the breakpoints
that were set in the previous process.
This menu entry is particularly useful if while debugging a program,
you discover you have gone too far, and would like to rerun the
program without going through the effort of opening the windows,
resetting the data formatting options, and placing the breakpoints.
.LE
